<?php
require_once '../config.php';

if(!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

$user_id = $_SESSION['user_id'];

// Get filter parameters
$type_filter = isset($_GET['type']) ? sanitize($_GET['type']) : '';
$status_filter = isset($_GET['status']) ? sanitize($_GET['status']) : '';
$search = isset($_GET['search']) ? sanitize($_GET['search']) : '';
$start_date = isset($_GET['start_date']) ? sanitize($_GET['start_date']) : '';
$end_date = isset($_GET['end_date']) ? sanitize($_GET['end_date']) : '';

// Build query
$where_conditions = ["user_id = $user_id"];
$params = [];
$types = "";

if($type_filter && $type_filter != 'all') {
    $where_conditions[] = "type = ?";
    $params[] = $type_filter;
    $types .= "s";
}

if($status_filter && $status_filter != 'all') {
    $where_conditions[] = "status = ?";
    $params[] = $status_filter;
    $types .= "s";
}

if($search) {
    $where_conditions[] = "(description LIKE ? OR id LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $types .= "ss";
}

if($start_date) {
    $where_conditions[] = "DATE(created_at) >= ?";
    $params[] = $start_date;
    $types .= "s";
}

if($end_date) {
    $where_conditions[] = "DATE(created_at) <= ?";
    $params[] = $end_date;
    $types .= "s";
}

$where_sql = !empty($where_conditions) ? "WHERE " . implode(" AND ", $where_conditions) : "";

// Get transactions
$transactions_sql = "SELECT * FROM transactions 
                     $where_sql 
                     ORDER BY created_at DESC";
$transactions_stmt = $conn->prepare($transactions_sql);
if($types) {
    $transactions_stmt->bind_param($types, ...$params);
}
$transactions_stmt->execute();
$transactions_result = $transactions_stmt->get_result();

// Set headers for CSV download
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=transactions_' . date('Y-m-d_H-i') . '.csv');

// Create output stream
$output = fopen('php://output', 'w');

// Add CSV headers
fputcsv($output, [
    'Transaction ID',
    'Type',
    'Amount',
    'Description',
    'Status',
    'Date'
]);

// Add data rows
while($transaction = $transactions_result->fetch_assoc()) {
    $amount = ($transaction['type'] == 'deposit' || $transaction['type'] == 'referral_bonus') ? 
              $transaction['amount'] : -$transaction['amount'];
    
    fputcsv($output, [
        '#' . str_pad($transaction['id'], 6, '0', STR_PAD_LEFT),
        ucfirst(str_replace('_', ' ', $transaction['type'])),
        number_format($amount, 2),
        $transaction['description'],
        ucfirst($transaction['status']),
        date('Y-m-d H:i:s', strtotime($transaction['created_at']))
    ]);
}

fclose($output);
?>